#include <iostream>
#include <vector>
#include <algorithm>
#include <cmath>
#include <climits> 
using namespace std;

struct Tacka {
    long long x, y;
    bool operator<(const Tacka& tacka) const {
        return (x < tacka.x || (x == tacka.x && y < tacka.y));
    }
};

long long vektProizvod(const Tacka& a, const Tacka& b, const Tacka& c) {
    return (b.x - a.x) * (c.y - a.y) - (b.y - a.y) * (c.x - a.x);
}

long long povrMnogougla(const vector<Tacka>& mnogougao) {
    long long povr = 0;
    int n = mnogougao.size();
    for (int i = 0; i < n; i++) {
        int j = (i + 1) % n;
        povr += mnogougao[i].x * mnogougao[j].y - mnogougao[i].y * mnogougao[j].x;
    }
    return abs(povr);
}

vector<Tacka> konvOmotac(vector<Tacka>& tacke) {
    sort(tacke.begin(), tacke.end());
    vector<Tacka> omotac;

    for (const auto& p : tacke) {
        while (omotac.size() >= 2 && vektProizvod(omotac[omotac.size() - 2], omotac.back(), p) <= 0) {
            omotac.pop_back();
        }
        omotac.push_back(p);
    }

    size_t lowerSize = omotac.size();
    for (auto it = tacke.rbegin(); it != tacke.rend(); ++it) {
        while (omotac.size() > lowerSize && vektProizvod(omotac[omotac.size() - 2], omotac.back(), *it) <= 0) {
            omotac.pop_back();
        }
        omotac.push_back(*it);
    }

    omotac.pop_back(); 
    return omotac;
}

int main() {
    int N;
    cin >> N;

    vector<Tacka> tacke(N);
    for (int i = 0; i < N; i++) {
        cin >> tacke[i].x >> tacke[i].y;
    }

    vector<Tacka> omotac = konvOmotac(tacke);
    long long najmanjaPovr = LLONG_MAX;

    for (size_t i = 0; i < omotac.size(); i++) {
        vector<Tacka> smanjeniOmotac = omotac;
        smanjeniOmotac.erase(smanjeniOmotac.begin() + i);
        najmanjaPovr = min(najmanjaPovr, povrMnogougla(smanjeniOmotac));
    }

    cout << najmanjaPovr / 2 << "\n";
    return 0;
}